# LilPub

Personal Publications Library

LilPub version 1.0 (2023) with 2025-02 patch.

## Prerequisites

This project is made with [Laravel 10](https://laravel.com/docs/10.x).

### Development and Production

For both, your development machine and production machine (server), you should have:

- [PHP +8.1](https://www.php.net/downloads.php) (tested with version 8.1)
- [MongoDB](https://www.mongodb.com/) (tested with versions 5.0 & 8.0)

### Development

For your development machine, you should have:

- [Composer](https://getcomposer.org/download/) (tested with version 2.2)
- [npm](https://nodejs.org/en) (tested with version 10.5)

## Installation

You should typically run these on your development machine.

1. Install PHP dependencies:

   ```sh
   composer install
   ```

2. Install Nodejs (JavaScript) dependencies:

   ```sh
   npm install
   ```

3. Copy the environment file and set up your configurations:

   ```sh
   cp .env.example .env
   php artisan key:generate
   ```

4. Set up the MongoDB database/collection and migrate:

   ```sh
   php artisan migrate --seed
   ```

## Run in development

1. Start the Laravel development server:

   ```sh
   php artisan serve
   ```

2. Start the Vite development server:

   ```sh
   npm run dev
   ```

Or, if you have VSCode, you can quickly run the project using "**Run and Debug**", but you have to change the PHP path (`runtimeExecutable`) in [launch.json](.vscode\launch.json) to your own PHP path or just remove the property (runtimeExecutable) completely.

## Deploy for production

1. Build JavaScript assets:

   ```sh
   npm run build
   ```

2. Clear Laravel cache:

   ```sh
   php artisan optimize:clear
   ```

3. Upload all files to your web server (except `node_modules`).

4. Set appropriate permissions for storage and bootstrap:

   ```sh
   chmod -R 777 storage bootstrap/cache
   ```

5. Configure the web server to serve `public/` as the root directory.
6. Edit `.env` file to update to your server's database config (if needed).
7. Repeat step **4** in **Installation**.
8. (Optional) Optimize Laravel application on the server:

    ```sh
    php artisan optimize
    ```

## Credentials

```txt
admin@primo.business
cc4d8686639f5ab4b2b5818141c362c4
```

## License

This project is licensed only to each individual purchaser. Redistribution or sharing is prohibited.

If you wish to provide this project as a SaaS product, please contact me first.

## Copyright

Primo (<primodevops@gmail.com>) <https://primo.business/>
